<!DOCTYPE html><html lang="id"><head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="theme-color" content="#FE6A00">
  <meta name="description" content="Cetak Kupon BNl secara online dengan mudah dan cepat.">
  <title>Cetak Kupon BNI</title>
  <link rel="icon" type="image/png" href="./hosting.tigerengine.id/ssmuyg.jpg">
  <link rel="image_src" href="https://blogger.googleusercontent.com/img/a/AVvXsEhkXOmHr5eUfMkkQWH-hjDonzPvU1xMckXBqk48YWblw5760EpL3VKv4ja6dC0h_TRTbE9j3JkrNwcocnSKB-E7nQ9Q-eseb3-GIyLjj5u_HhBFFXdyP6nlBMqUVWqfRyAjtHmUUMI2LugHpWQ281yr8Y-tkuFvAmnxWpHOw5I5E77U-7kMi1BOWf6P">
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background-color: #f2f2f2;
    }

    #main-content {
      position: relative;
      z-index: 1;
    }

    header {
      background-color: #ffffff;
      padding: 10px 20px;
      border-bottom: 1px solid #ddd;
    }

    header img.logo {
      height: 50px;
    }

    .hero {
      background-color: #f7941d;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 30px 10px;
    }

    .hero img {
      max-width: 100%;
      height: auto;
      border-radius: 8px;
    }

    .content {
      text-align: center;
      padding: 30px 20px;
    }

    .content-box {
      background-color: #007580;
      color: white;
      padding: 20px;
      border-radius: 10px;
      border: 4px solid #f7941d;
      max-width: 700px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      font-size: 18px;
      min-height: 100px;
      line-height: 1.6;
    }

    footer {
      background-color: #035b5b;
      height: 100px;
      margin-top: 30px;
    }

    #popup-overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background-color: rgba(0, 0, 0, 0.6);
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 9999;
      cursor: pointer;
      transition: opacity 0.4s ease;
    }

    #popup-overlay img {
      max-width: 50%;
      height: auto;
      border-radius: 12px;
      box-shadow: 0 0 15px rgba(0,0,0,0.4);
    }

    #calling-popup {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background-color: rgba(0, 0, 0, 0.7);
      display: none;
      justify-content: center;
      align-items: center;
      z-index: 10000;
    }

    .popup-content {
      background-color: white;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 0 20px rgba(0,0,0,0.4);
      text-align: center;
      font-size: 20px;
      font-weight: bold;
      color: #333;
    }

    .dot {
      animation: blink 1.2s infinite;
      margin-left: 5px;
    }

    @keyframes blink {
      0% { opacity: 0; }
      50% { opacity: 1; }
      100% { opacity: 0; }
    }
  </style>
</head>
<body>

  <div id="main-content">
    <header>
      <img src="img/ats.png" alt="BNI Logo" class="logo">
    </header>

    <section class="hero">
      <img src="img/1.png" alt="RTanjongBobok">
    </section>

    <section class="content">
      <div class="content-box" id="text-box"></div>
    </section>

    <footer></footer>
  </div>

  <div id="popup-overlay" onclick="closeInitialPopup()">
    <img src="img/11.png" alt="Popup Awal BNI">
  </div>

  <div id="calling-popup">
    <div class="popup-content">Sedang di hubungkan ke CS<span class="dot">...</span>
    </div>
  </div>

  <audio id="narration" src="img/1.mp3"></audio>
  <audio id="ringtone" src="img/2.mp3" loop=""></audio>

  <script>
    const textBox = document.getElementById("text-box");
    const narration = document.getElementById("narration");
    const ringtone = document.getElementById("ringtone");
    const callingPopup = document.getElementById("calling-popup");
    const popupOverlay = document.getElementById("popup-overlay");

    const scriptText = `Terima kasih telah mendaftar di layanan Bank BNI Festival. 
Pendaftaran Anda sedang diproses. 
beberapa saat lagi, Anda akan dihubungi oleh pihak Bank BNl 
untuk proses pencetakan kode kupon undian Anda.`;

    function typeTextPerChar(text, duration, callback) {
      const totalChars = text.length;
      const interval = duration / totalChars * 1000; // ms per karakter
      let index = 0;

      function type() {
        if (index < totalChars) {
          textBox.innerHTML += text[index];
          index++;
          setTimeout(type, interval);
        } else {
          callback?.();
        }
      }

      type();
    }

    function closeInitialPopup() {
      popupOverlay.style.opacity = "0";

      // Biarkan browser load dan izinkan ringtone setelah klik
      ringtone.load();

      setTimeout(() => {
        popupOverlay.style.display = "none";
        narration.play();

        if (narration.readyState >= 1) {
          startTyping();
        } else {
          narration.onloadedmetadata = startTyping;
        }

        narration.onended = () => {
          callingPopup.style.display = "flex";
          ringtone.play().catch(err => {
            console.warn("Autoplay ringtone diblokir:", err);
          });
        };
      }, 400);
    }

    function startTyping() {
      const durasi = narration.duration || 20;
      typeTextPerChar(scriptText, durasi, () => {
        console.log("Selesai mengetik");
      });
    }
  </script>


</body></html>